/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.gui;

import com.github.charlyb01.music_control.ResourcePackUtils;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.gui.components.Button;
import com.github.charlyb01.music_control.gui.components.SoundConfigPanel;
import com.github.charlyb01.music_control.gui.components.SoundListPanel;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WCardPanel;
import io.github.cottonmc.cotton.gui.widget.WText;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_437;
import net.minecraft.class_5375;

public class ConfigPanel
extends WBox {
    protected static boolean isEvent = true;
    protected Button selectedButton;
    protected SoundConfigPanel soundConfigPanel;
    protected WCardPanel cardPanel = new WCardPanel();
    protected WBox resourcePackCard = new WBox(Axis.VERTICAL);
    protected WBox musicConfigCard = new WBox(Axis.VERTICAL);
    protected class_437 previousScreen = null;
    protected final class_310 client;

    public ConfigPanel(class_310 client) {
        super(Axis.VERTICAL);
        this.setInsets(Insets.ROOT_PANEL);
        this.setHorizontalAlignment(HorizontalAlignment.LEFT);
        this.client = client;
        this.setupResourcePackPanel();
        this.setupConfigMusicPanel();
        this.cardPanel.add((WWidget)this.resourcePackCard);
        this.cardPanel.add((WWidget)this.musicConfigCard);
        this.add((WWidget)this.cardPanel);
        this.updateLayout();
    }

    private void updateLayout() {
        if (ResourcePackUtils.wasCreatedOrIsEnabled()) {
            this.musicConfigCard.layout();
            this.cardPanel.setSelectedCard((WWidget)this.musicConfigCard);
        } else {
            this.resourcePackCard.layout();
            this.cardPanel.setSelectedCard((WWidget)this.resourcePackCard);
        }
    }

    private void backToMusicScreen(class_3283 manager) {
        this.client.field_1690.method_49598(manager);
        this.client.method_1507(this.previousScreen);
        this.previousScreen = null;
        this.updateLayout();
    }

    private void setupResourcePackPanel() {
        WText text = new WText((class_2561)class_2561.method_43471((String)"gui.music_control.label.resourcePack"));
        text.setHorizontalAlignment(HorizontalAlignment.CENTER);
        WButton enableButton = new WButton((class_2561)class_2561.method_43471((String)"gui.music_control.button.enable"));
        enableButton.setEnabled(ResourcePackUtils.exists());
        enableButton.setOnClick(() -> {
            this.previousScreen = this.client.field_1755;
            this.client.method_1507((class_437)new class_5375(this.client.method_1520(), this::backToMusicScreen, this.client.method_1479(), (class_2561)class_2561.method_43471((String)"resourcePack.title")));
        });
        WButton createButton = new WButton((class_2561)class_2561.method_43471((String)"gui.music_control.button.create"));
        createButton.setOnClick(() -> {
            ResourcePackUtils.createResourcePack();
            this.updateLayout();
        });
        WBox buttonsBox = new WBox(Axis.HORIZONTAL);
        buttonsBox.setHorizontalAlignment(HorizontalAlignment.CENTER);
        buttonsBox.add((WWidget)enableButton, 100, 20);
        buttonsBox.add((WWidget)createButton, 100, 20);
        this.resourcePackCard.add((WWidget)text, ModConfig.get().cosmetics.gui.width, 20);
        this.resourcePackCard.add((WWidget)buttonsBox, ModConfig.get().cosmetics.gui.width, 20);
    }

    private void setupConfigMusicPanel() {
        WBox listsBox = new WBox(Axis.HORIZONTAL);
        int outerWidth = ModConfig.get().cosmetics.gui.width;
        int innerWidth = ModConfig.get().cosmetics.gui.width - 4;
        BiConsumer<class_2960, Button> onSoundClicked = (identifier, button) -> {
            if (this.selectedButton != null) {
                this.selectedButton.setEnabled(true);
            }
            this.selectedButton = button;
            this.selectedButton.setEnabled(false);
            if (this.soundConfigPanel != null) {
                listsBox.remove((WWidget)this.soundConfigPanel);
            }
            this.soundConfigPanel = new SoundConfigPanel((class_2960)identifier, isEvent, innerWidth / 2);
            listsBox.add((WWidget)this.soundConfigPanel);
            this.soundConfigPanel.setHost(listsBox.getHost());
            listsBox.layout();
        };
        Consumer<Boolean> onToggle = isEvent -> {
            ConfigPanel.isEvent = isEvent;
            if (this.soundConfigPanel != null) {
                listsBox.remove((WWidget)this.soundConfigPanel);
                this.soundConfigPanel = null;
                if (this.selectedButton != null) {
                    this.selectedButton.setEnabled(true);
                    this.selectedButton = null;
                }
            }
        };
        listsBox.add((WWidget)new SoundListPanel(onSoundClicked, onSoundClicked, onToggle, innerWidth / 2, ConfigPanel.isEvent));
        WButton saveButton = new WButton((class_2561)class_2561.method_43471((String)"gui.music_control.button.save"));
        saveButton.setOnClick(() -> {
            ResourcePackUtils.writeConfig();
            this.client.method_1521();
        });
        WBox buttonBox = new WBox(Axis.HORIZONTAL);
        buttonBox.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        buttonBox.add((WWidget)saveButton, 100, 20);
        this.musicConfigCard.add((WWidget)listsBox, outerWidth, ModConfig.get().cosmetics.gui.height - 20);
        this.musicConfigCard.add((WWidget)buttonBox, outerWidth, 20);
    }
}

